EXECTEST()

OWNER(
    g:crypta
)

RUN(
    NAME api_production
    CWD ${ARCADIA_ROOT}/crypta/ltp/viewer/services/api/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "production", "port": 80}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME api_qa
    CWD ${ARCADIA_ROOT}/crypta/ltp/viewer/services/api/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "port": 1234, "topic": "/topic/", "logbroker_server": "localhost", "logbroker_port": 2345, "tvm_id": 100500}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME http_proxy
    CWD ${ARCADIA_ROOT}/crypta/ltp/viewer/services/api/docker/templates

    render_and_check_yaml
    --template http_proxy_config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"http_port": 1234, "grpc_port": 2345}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME expire
    CWD ${ARCADIA_ROOT}/crypta/ltp/viewer/services/api/docker/templates

    render_and_check_yaml
    --template expire.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "grpc_port": 2345}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/ltp/viewer/services/api/docker/templates/config.template.yaml
    arcadia/crypta/ltp/viewer/services/api/docker/templates/expire.template.yaml
    arcadia/crypta/ltp/viewer/services/api/docker/templates/http_proxy_config.template.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
