import argparse
import logging
import os

from crypta.lib.python.logging import logging_helpers
from crypta.ltp.viewer.services.build_index.lib import LTPIndexUpdate


def make_arg_parser():
    parser = argparse.ArgumentParser(description="LTP index update")
    parser.add_argument(
        "--start-date", help="Date for start of update period. Example: 2021-12-12", required=False, default=""
    )
    parser.add_argument(
        "--end-date", help="Date for end of update period. Example: 2021-12-13", required=False, default=""
    )
    parser.add_argument(
        "--min-history-date", help="Date for cleanup history. Example: 2021-12-01", required=False, default=""
    )
    parser.add_argument(
        "--index-path",
        help="YT path to compact index. Example: //home/crypta/{env}/portal/ltp/ids_index_compact_hdd",
        required=False,
        default="",
    )
    parser.add_argument(
        "--crypta-ltp-viewer-udf-url",
        help="LTP Viewer UDF URL",
        required=False,
        default="yt://hahn/home/crypta/public/udfs/libcrypta_ltp_viewer_udf.so",
    )

    return parser


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = make_arg_parser().parse_args()

    yt_proxy = os.getenv("YT_PROXY", "hahn.yt.yandex.net")
    yt_pool = os.getenv("YT_POOL", "crypta_graph")

    LTPIndexUpdate(
        yt_proxy=yt_proxy,
        pool=yt_pool,
        hdd_index_path=args.index_path,
        start_date=args.start_date,
        end_date=args.end_date,
        min_history_date=args.min_history_date,
        crypta_ltp_viewer_udf_url=args.crypta_ltp_viewer_udf_url,
    ).run()
