$end_date = '{{ end_date }}';
$index = '{{ index }}';

PRAGMA File('libcrypta_ltp_viewer_udf.so', '{{ crypta_ltp_viewer_udf_url }}');
PRAGMA Udf('libcrypta_ltp_viewer_udf.so');

$all_log_ids = (
{% for source, path in input_paths %}
    {% set log_start_date = start_date if path in computed_logs and current_min_history_date <= min_history_date else min_history_date %}
    SELECT
        id,
        id_type,
        TableName() AS `date`,
        "{{ source }}" AS source
    FROM RANGE("{{ path }}", '{{ log_start_date }}', $end_date)
    {{ "UNION ALL\n" if not loop.last}}
{% endfor %}
);

$new_entries = (
    SELECT
        id,
        id_type,
        AGGREGATE_LIST(AsTuple(source, `date`)) AS sources,
    FROM (
        SELECT
            DISTINCT
            id,
            id_type,
            source,
            `date`,
        FROM $all_log_ids
        WHERE id IS NOT NULL AND id_type IS NOT NULL
    )
    GROUP BY id, id_type
);

INSERT INTO $index WITH (TRUNCATE, USER_ATTRS='{{ user_attrs }}')
SELECT
    cur.id ?? new.id AS id,
    cur.id_type ?? new.id_type AS id_type,
    LtpViewer::AddToIndex(cur.sources ?? "", new.sources ?? []) AS sources,
FROM $index AS cur
FULL JOIN $new_entries as new
USING (id, id_type)
ORDER BY id, id_type;
