import signal

from crypta.lib.python.lb_pusher import logbroker
from crypta.lib.python.lb_pusher.reader_config import ReaderConfig
from crypta.lib.python.worker_utils.proto_reader import ProtoReader
from crypta.lib.python.worker_utils.stats_server import StatsServer
from crypta.ltp.viewer.proto import command_pb2
from crypta.ltp.viewer.services.worker.lib import stats
from crypta.ltp.viewer.services.worker.lib.context import Context
from crypta.ltp.viewer.services.worker.lib.task_queue import TaskQueue


def run(config, logger):
    pq_client = logbroker.PQClient(
        config.Logbroker.Url,
        config.Logbroker.Port,
        tvm_id=config.Tvm.SourceTvmId,
        tvm_secret=config.Tvm.Secret,
    )
    pq_reader = pq_client.get_async_reader(ReaderConfig(topic=config.Topic, client_id=config.Consumer, max_count=1))
    context = Context()
    task_queue = TaskQueue(pq_reader.done_cookies, config, context, stats.get_metrics())
    stats_server = StatsServer(config.StatsHost, config.StatsPort, task_queue.mp_metric_registry)
    reader = ProtoReader(task_queue.schedule, command_pb2.TCommand)

    signal.signal(signal.SIGTERM, lambda *args: pq_reader.stop())
    stats_server.start()

    with task_queue, pq_client, pq_reader:
        logger.info("Reading dicts")
        context.start(config)

        logger.info("Starting loop")
        pq_reader.loop(reader.schedule)
