from crypta.lib.python.spine.consts.yt_proxy import YtProxy


class UniversalTask(object):
    def __init__(
        self,
        bundle_name,
        binary,
        kill_timeout,
        crit_time,
        aggr_hosts,
        yt_dependencies=YtProxy.Group.offline,
        templates=None,
        subprogram=None,
        additional_env=None,
        schedule_interval=None,
        schedule_daily_start_time=None,
        retry_interval=None,
        use_semaphore=True,
    ):
        self.bundle_name = bundle_name
        self.binary = binary
        self.kill_timeout = kill_timeout
        self.crit_time = crit_time
        self.aggr_hosts = aggr_hosts
        self.yt_dependencies = yt_dependencies
        self.subprogram = subprogram
        self.additional_env = additional_env
        self.schedule_daily_start_time = schedule_daily_start_time
        self.schedule_interval = schedule_interval
        self.retry_interval = retry_interval
        self.use_semaphore = use_semaphore
        self.templates = templates if templates is not None else []


def create_run_universal_bundle_schedulers(sandbox, task):
    for aggr_host in task.aggr_hosts:
        scheduler = sandbox.create_run_universal_bundle_scheduler(
            bundle_name=task.bundle_name,
            cmd=_cmd(task.binary, task.subprogram, task.templates),
            additional_env=task.additional_env,
            templates=task.templates,
            env=aggr_host.environment,
            juggler_service=sandbox_juggler_service(task.bundle_name, task.subprogram),
            schedule_interval=task.schedule_interval,
            schedule_daily_start_time=task.schedule_daily_start_time,
            retry_interval=task.retry_interval,
            kill_timeout=task.kill_timeout,
            semaphore_name=sandbox_semaphore_name(task.bundle_name, task.subprogram, aggr_host.environment),
            use_semaphore=task.use_semaphore,
        )
        scheduler.check(crit_time=task.crit_time).set_host(aggr_host.host).add_yt_dependencies(task.yt_dependencies)


def _cmd(binary, subprogram, templates):
    cmd = ["{{{{cwd}}}}/{binary}".format(binary=binary)]

    if subprogram is not None:
        cmd.append(subprogram)

    if "config.yaml" in templates:
        cmd += ["--config", "{{cwd}}/config.yaml"]

    return cmd


def sandbox_juggler_service(bundle_name, subprogram=None):
    return bundle_name if subprogram is None else "{}-{}".format(bundle_name, subprogram)


def sandbox_semaphore_name(bundle_name, subprogram, environment):
    return "CryptaRunUniversalBundle_{}_{}_{}".format(bundle_name, subprogram, environment)
