from datetime import timedelta

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.solomon import (
    solomon_alert_utils,
    solomon_check_generator,
)
from crypta.lib.python.spine.juggler import (
    consts,
    juggler_check_generator,
)


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(
        host="crypta-keyboard-collector",
        child_group_type=consts.GroupType.host,
        child_group="crypta-keyboard-collector-solomon",
        tags=["crypta-keyboard-collector"],
    )

    solomon = solomon_check_generator.SolomonCheckGenerator(
        juggler,
        solomon_alert_utils.AlertCreator(
            project_id="crypta_stats",
            selectors={},
        ),
    )

    buzzard_all_prod_clusters = "buzzrd_1|buzzard_2|buzzard_3|buzzard_4"

    solomon.create_sensor_aggregation_check(
        service="KeyboardCollector_total_processed_count",
        period=timedelta(hours=1),
        labels={
            "project": "buzzard",
            "cluster": buzzard_all_prod_clusters,
            "sensor": "keyboard.processed",
            "service": buzzard_all_prod_clusters,
            "host": "cluster",
            "servant": "buzzard",
        },
        predicate=alert_pb2.LT,
        threshold=200000,
        description="Average amount of processed AppMetrika events={{ expression.total }} is below the threshold={{ expression.threshold }}",
    )

    solomon.create_sensor_aggregation_check(
        service="KeyboardCollector_with_events_count",
        period=timedelta(hours=1),
        labels={
            "project": "buzzard",
            "cluster": buzzard_all_prod_clusters,
            "sensor": "keyboard.with_events",
            "service": buzzard_all_prod_clusters,
            "host": "cluster",
            "servant": "buzzard",
        },
        predicate=alert_pb2.LT,
        threshold=0.05,
        description="Average amount of processed keyboard ecom events={{ expression.total }} is below the threshold={{ expression.threshold }}",
    )

    return juggler
