import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.juggler import (
    consts,
    juggler_check_generator,
)
from crypta.lib.python.spine.solomon import (
    solomon_alert_utils,
    solomon_check_generator,
)


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(
        host="crypta-chyt-clique",
        child_group_type=consts.GroupType.host,
        child_group="crypta-chyt-clique-solomon",
        tags=["crypta-stats"],
    )
    solomon = solomon_check_generator.SolomonCheckGenerator(
        juggler,
        solomon_alert_utils.AlertCreator(
            project_id="crypta_stats",
            selectors={"project": "yt", "cluster": "hahn", "operation_alias": "crypta"}
        )
    )

    solomon.get_sensor({
        "sensor": "yt.clickhouse.yt.health_checker.success",
        "service": "clickhouse",
        "cookie": "Aggr",
        "query_index": "*",
        "user": "-",
    }).create_threshold_check(
        aggregation=alert_pb2.MAX,
        predicate=alert_pb2.EQ,
        threshold=0,
        period=datetime.timedelta(hours=1),
        juggler_service="healthchecker",
        description="Clique is not responding",
    )

    return juggler
