#!/usr/bin/env python
# -*-coding: utf-8 -*-
# vim: sw=4 ts=4 expandtab ai
#
# Provides: chkdisk


import os
import sys
import time
import datetime
from glob import glob


MONFILE = '/tmp/yabs-chkdisk-monitoring'
TMPFILE = '/tmp/yabs-chkdisk-tmp'
NOACTIONFLAG = '/etc/yabs-chkdisk-stop'
NOACTION_TIMEAUT = 26*3600
CHECK_TIME = [(10, 22)]
VIRTUALHOST_FLAG = '/etc/virtual-host'


def main():
    if os.path.exists(VIRTUALHOST_FLAG):
        out('0;Virtual host, no monitoring needed')

    # Find stop flag
    if os.path.exists(NOACTIONFLAG):
        out_data = check_raid()
        if out_data:
            out('%d;%s' % (max([md_state[0] for md_state in out_data]),
                           ', '.join([md_state[1] for md_state in out_data])))
        else:
            out('1;NoActionFlag set')

    # Check time
    check_accept = False
    for mint, maxt in CHECK_TIME:
        check_accept = check_accept or (mint <= datetime.datetime.today().hour <= maxt)
    if not check_accept:
        out('0;OK')

    if os.path.exists(MONFILE):
        # Check out from yabs-chkdisk
        if os.path.exists(TMPFILE):
            os.remove(TMPFILE)

        if (time.time() - os.stat(MONFILE).st_mtime) >= NOACTION_TIMEAUT:
            out('2;Too long no action')
        else:
            try:
                monfile = open(MONFILE)
                data = monfile.read()
            finally:
                monfile.close()
            if data:
                out(data)
            else:
                out('2;No data in monitoring file')
    else:
        if os.path.exists(TMPFILE):
            try:
                tmpfile = open(TMPFILE)
                oldtime = eval(tmpfile.read())
            finally:
                tmpfile.close()
            if (time.time() - oldtime) >= NOACTION_TIMEAUT:
                out('2;Too long no action')
            else:
                out('1;Waiting action...')

        else:
            try:
                tmpfile = open(TMPFILE, 'w')
                tmpfile.write(str(time.time()))
            finally:
                tmpfile.close()
            out('1;Waiting action...')


def check_raid():
    out_data = []
    for md_path in glob("/sys/block/md*"):
        md_name = os.path.basename(md_path)

        degraded = False
        degraded_info_file = os.path.join(md_path + "/md/degraded")
        if os.path.exists(degraded_info_file):
            deg_count = open(degraded_info_file).read().strip()
            if int(deg_count):
                degraded = True

        resynced = False
        sync_info_file = os.path.join(md_path + "/md/sync_completed")
        if os.path.exists(sync_info_file):
            sync_completed = open(sync_info_file).read().strip()
            if sync_completed != 'none':
                resynced = True

        if degraded:
            if resynced:
                out_data.append( (1,'%s resynced' % md_name) )
            else:
                out_data.append( (2,'%s degraded' % md_name) )
    return out_data


def out(message):
    print 'PASSIVE-CHECK:chkdisk;%s' % message
    sys.exit(0)


if __name__ == '__main__':
    main()
