#!/usr/bin/perl
#
# Provides: coredumps_mon

use strict;
use POSIX qw(strftime);
use IPC::Open3;
use Time::Local;
use File::ReadBackwards;

my $log_file="/var/log/messages";
my $core_count_crit=1;
my $crit_time=3600;
my $mon_period=300; # tail last 300sec of log_file

my $filename = "/coredumps";

my $mode = sprintf("%04o", (stat($filename))[2] & 07777);

my $pid;
my ($wtr, $rdr, $err);
$pid = open3($wtr, $rdr, $err, "mount | grep coredumps");
waitpid( $pid, 0 );

if ($? != 0) {
    mexit(2,"No coredumps mounted!");
}

if ((my $line = <$rdr>) && ($mode == 1777)) {
    my $pid;
    my ($wtr, $rdr, $err);
    $pid = open3($wtr, $rdr, $err, "/sbin/sysctl kernel.core_pattern");
    waitpid( $pid, 0 );
    if ($? != 0) {
        mexit(2,"kernel.core_pattern incorrect!");
    }
    my $line = <$rdr>;
    $line =~ /.*=\s(.*)$/;
    if ($1 ne "/coredumps/%e.%t.%p.core") {
        mexit(2, "kernel.core_pattern incorrect!");
    }
    $pid = open3($wtr, $rdr, $err, "/sbin/sysctl kernel.core_uses_pid");
    waitpid( $pid, 0 );
    if ($? != 0) {
        mexit(2,"kernel.core_uses_pid incorrect!");
    }
    my $line = <$rdr>;
    $line =~ /.*=\s(.*)$/;
    if ($1 ne "1") {
        mexit(2,"kernel.core_uses_pid incorrect!");
    }
    #  mexit(0,"OK");
}
else {
    mexit(2,"/coredumps is ".$mode);
}

# check log for segfaults
if ( -f $log_file) {
    my $log=File::ReadBackwards->new($log_file);
    my $core_count=0;
    while (my $line = $log->readline()) {
        if ($line=~/(\w+\s+\d+\s+\d+:\d+:\d+)\s+.*/) {
            my $log_time=convert_time($1);
            if ($log_time and (time() - $log_time) < $mon_period) {
                if ($line=~/segfault/) {
                    $core_count++;
                    if ($core_count > $core_count_crit) {
                        mexit(2,"Core dumped more than ".$core_count_crit." times!");
                    }
                }
            }
            else {
                last;
            }
        }
    }
}

# check coredumps folder for new coredumps
my @cores=glob("/coredumps/*.core");
foreach  my $core (@cores) {
    my $core_mtime=(stat($core))[9];
    if ((time() - $core_mtime) < $crit_time) {
        mexit(2,"New coredump found!");
    }
}

mexit(0,"OK");

sub convert_time{
    my $time=shift;
    if ($time=~/(\w+\s+\d+\s+\d+:\d+:\d+)/) {
        my %monthes=("Jan" => 0, "Feb" => 1,"Mar" => 2, "Apr" => 3, "May" => 4, "Jun" => 5, "Jul" => 6, "Aug" => 7, "Sep" => 8, "Oct" => 9, "Nov" => 10, "Dec" => 11);
        my ($mon,$mday,$hour,$min,$sec) = $time =~/(\w+)\s+(\d+)\s+(\d+):(\d+):(\d+)/;
        my $year=strftime("%Y",localtime());
        if (exists($monthes{$mon})) {
            $mon=$monthes{$mon};
        }
        else {
            return 0;
        }
        my $task_time=timelocal($sec,$min,$hour,$mday,$mon,$year) or return 0;
        return $task_time;
    }
    else {
        return 0;
    }
}

sub mexit {
    my ($status,$msg) = @_;
    $msg=substr($msg,0,1024);
    print "PASSIVE-CHECK:coredumps_mon;$status;$msg\n";
    exit(0);
}
