#!/usr/bin/env bash
#
# Provides: memory_check

die () {
    echo "PASSIVE-CHECK:memory_check;$1;$2"
    exit 0
}

MEM_CFG_DIR="/home/monitor/agents/etc"
MEM_CFG="$MEM_CFG_DIR/memory_check_crypta.conf"

MEM=`cat /proc/meminfo | grep MemTotal | awk '{ print $2 }'`;
MEM=$(( MEM/1000/1000 ));

if ! [ -e "$MEM_CFG" ]; then
    mkdir -p "$MEM_CFG_DIR"
    echo "$MEM" > "$MEM_CFG";
fi

MEM_TOTAL="$(cat "$MEM_CFG")"

if [ "$MEM" -lt "$MEM_TOTAL" ]; then
    die 2 "Failed memory detected"
else
    die 0 "Memory OK"
fi
