from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine.juggler import juggler_check_generator


QUOTAS = [
    "chunk",
    "disk",
    "node",
    "tablet_static",
]


def add_check(juggler, host, proxies, account):
    juggler.any(account).set_host(host).set_multiple_children(
        proxies,
        ["yt_{account}_{quota}_quota".format(account=account, quota=quota) for quota in QUOTAS],
    )


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-yt"])

    accounts = [
        "crypta-audience",
        "crypta-audience-testing",
        "crypta-buchhalter",
        "crypta-cookie-matching",
        "crypta-cookie-matching-testing",
        "crypta-dmp",
        "crypta-dmp-testing",
        "crypta-external-ads",
        "crypta-lab",
        "crypta-lab-testing",
        "crypta-lookalike",
        "crypta-lookalike-testing",
        "crypta-profiles",
        "crypta-profiles-testing",
        "crypta-s2s",
        "crypta-siberia",
        "crypta-team",
        "crypta-testing",
        "crypta-tx",
        "logfeller-crypta",
    ]

    dyntable_accounts = [
        ("crypta-cm", YtProxy.Group.dyntable_prod_without_man + (YtProxy.markov,)),
    ]

    for account in accounts:
        add_check(
            juggler,
            "crypta-yt-quotas",
            YtProxy.Group.offline,
            account,
        )

    for account, proxies in dyntable_accounts:
        add_check(
            juggler,
            "crypta-yt-dyntable-quotas",
            proxies,
            account,
        )

    return juggler
