#!/bin/bash -eu

source /usr/share/crypta/autoinit/autoinit-config.sh

DEFAULT_RUNLEVEL='N 2'

echo -e "\nStarted at $(date)"

runlevel=$(/sbin/runlevel)
echo "Runlevel: '$runlevel'"

if [[ "$runlevel" != "$DEFAULT_RUNLEVEL" ]]; then
    echo "Runlevel is not default ($DEFAULT_RUNLEVEL), so doing nothing"
    exit 0
fi

host=$(hostname -f)

conductor_url="$CONDUCTOR_URL/api/hosts2tags/$host"
echo "Trying to get tags from Conductor: $conductor_url"
tags=$(curl -s -f "https://c.yandex-team.ru/api/hosts2tags/$host")

echo -e "Got tags:\n$tags\n"

if ! echo "$tags" | grep -qP "^$AUTO_INIT_TAG\$"; then
    echo "No init because no tag '$AUTO_INIT_TAG' found"
    exit 0
fi

if ! echo "$tags" | grep -qP "^$AUTO_INIT_DISABLE_TAG\$"; then
    echo "All OK, init!"
    /sbin/init 3
    echo "New runlevel: '$(/sbin/runlevel)'"
    exit 0
else
    echo "No init because tag '$AUTO_INIT_DISABLE_TAG' found"
fi
