from crypta.lib.python import templater


filter_join_query = """
{% if not is_logos_test %}

$bigb_so_url = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}';
PRAGMA File('bigb.so', $bigb_so_url);
PRAGMA udf('bigb.so');

pragma file('libparser_udf.so', 'sbr://3297671303');
pragma udf('libparser_udf.so');

{% endif %}

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.AutoMerge="disabled";
PRAGMA yt.UseNativeYtTypes;


$id_type_to_name = ToDict(AsList(
    AsTuple(0,  'UNKNOWN'),
    AsTuple(12, 'UNKNOWN_DEVICE_ID'),
    AsTuple(1,  'YANDEX_UID'),
    AsTuple(2,  'CRYPTA_ID1'),
    AsTuple(3,  'XUNIQ_GUID'),
    AsTuple(4,  'CRYPTA_ID2'),
    AsTuple(5,  'UNKNOWN_YID'),
    AsTuple(14, 'PRIVATE_YANDEX_UID'),
    AsTuple(6,  'PUID'),
    AsTuple(7,  'UUID'),
    AsTuple(8,  'GAID'),
    AsTuple(9,  'IDFA'),
    AsTuple(19, 'IFV'),
    AsTuple(10, 'MM_DEVICE_ID'),
    AsTuple(15, 'OAID'),
    AsTuple(11, 'MAC'),
    AsTuple(16, 'MAC_EXT_MD5'),
    AsTuple(13, 'DUID'),
    AsTuple(17, 'EMAIL_MD5'),
    AsTuple(18, 'PHONE_MD5'),
    AsTuple(20, 'SSP_USER_ID'),
));

$main_ids_lifetime = ($profile_dump, $showtime) -> {
    RETURN ToDict(
        ListMap(
            ListFilter(
                COALESCE(Bigb::ParseProfile($profile_dump).source_uniqs, EmptyList()),
                ($id_info) -> { RETURN $id_info.is_main; }
            ),
            ($id_info) -> {
                RETURN AsTuple(
                    $id_type_to_name[$id_info.id_type],
                    ($showtime - COALESCE($id_info.create_time, $showtime)) / 60. / 60.
                );
            }
        )
    );
};

$id_to_lifetime = ToDict(AsList(
    AsTuple("YANDEX_UID", 24),
    AsTuple("PRIVATE_YANDEX_UID", 24),
    AsTuple("GAID", 24),
    AsTuple("PUID", 24),
    AsTuple("DUID", 24 * 365),
    AsTuple("IDFA", 24 * 365),
    AsTuple("IFV", 24 * 365),
    AsTuple("OAID", 24 * 365),
));

$is_poor = ($ids) -> {
    $if_selected_ids_present = ListLength(
        ListFilter(DictKeys($ids), ($id) -> { RETURN DictContains($id_to_lifetime, $id); })
    ) > 0;
    $if_filtered_by_lifetime = ListLength(
        ListFilter(DictItems($ids), ($id) -> { RETURN DictContains($id_to_lifetime, $id.0) AND DictLookup($id_to_lifetime, $id.0) < $id.1; })
    ) > 0;
    RETURN $if_selected_ids_present AND NOT $if_filtered_by_lifetime;
};

$clicked_hits_parsed = SELECT * FROM (
    SELECT
        UniqID,
        HitLogID,
        ShowTime,
        SOME(IsClickedHit) AS IsClickedHit,
        UdfFromParser::NomzodParserUser(SOME(ProfileDump) ?? "", CAST(ShowTime AS Uint64)) AS User,
        UdfFromParser::NomzodParserPage(SOME(PageContextProto) ?? "", CAST(ShowTime AS Uint64)) AS Page,
    FROM `{{ ads_joined_profiles }}`
    WHERE
        IsRsya == true
        AND FraudBits == 0
        AND IsClickedHit == True
        AND (
            $is_poor($main_ids_lifetime(ProfileDump, ShowTime))
            OR SSPID > 10000
        )
    GROUP BY UniqID, HitLogID, ShowTime
) FLATTEN COLUMNS;


$banner_candidates_parsed = SELECT * FROM (
    SELECT
        UniqID,
        HitLogID,
        BannerID,
        ShowTime,
        CAST(IsClick AS Int32) AS IsClick,
        RealCost,
        SelectType,
        EventCost,
        FromHit,
        UdfFromParser::NomzodParserBanner(BannerProfileNoTsar ?? "", CAST(ShowTime AS Uint64)) AS Banner,
        UdfFromParser::NomzodParserOrder(OrderProfile ?? "", CAST(ShowTime AS Uint64)) AS Order,
        UdfFromParser::NomzodParserAdGroup(AdGroupProfile ?? "", CAST(ShowTime AS Uint64)) AS AdGroup,
        FROM `{{ qm_candidates_log }}`
    WHERE FraudBits == 0
) FLATTEN COLUMNS;


INSERT INTO `{{ output_log }}`
WITH TRUNCATE

SELECT *
FROM $clicked_hits_parsed AS clicked_hits
JOIN $banner_candidates_parsed AS banner_candidates
USING (UniqID, HitLogID, ShowTime);
"""


def run(
    yql_client,
    ads_joined_profiles,
    qm_candidates_log,
    output_log,
    is_logos_test=False,
):
    yql_client.execute(
        templater.render_template(
            filter_join_query,
            vars={
                'is_logos_test': is_logos_test,
                'output_log': output_log,
                'ads_joined_profiles': ads_joined_profiles,
                'qm_candidates_log': qm_candidates_log,
            },
        ),
    )
