from crypta.lib.python import templater


filter_join_query = """
{% if not is_logos_test %}

$bigb_so_url = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}';
PRAGMA File('bigb.so', $bigb_so_url);
PRAGMA udf('bigb.so');

pragma file('libparser_udf.so', 'sbr://3297671303');
pragma udf('libparser_udf.so');

{% endif %}

PRAGMA yt.AutoMerge="disabled";
PRAGMA yt.UseNativeYtTypes;

$get_main_ids_create_time = ($ProfileDump, $ShowTime) -> {
    $parsed = Bigb::ParseProfile($ProfileDump);
    RETURN ListMin(ListMap(
        ListFilter(
            $parsed.source_uniqs,
            ($id_info) -> { RETURN $id_info.is_main; }
        ),
        ($id_info) -> { RETURN COALESCE($id_info.create_time, $ShowTime); })
    );
};

$proto_pool = (
    SELECT
        HitLogID,
        UniqID,
        UniqIDSource,
        ShowTime,
        BannerID,

        IsClick,
        RealCost,
        EventCost,

        SelectType,
        SSPID,
        profiles.PageID AS PageID,
        profiles.DomainID AS DomainID,

        ProfileDump,
        BannerProfileNoTsar,
        OrderProfile,
        AdGroupProfile,
        PageContextProto,

        $get_main_ids_create_time(ProfileDump, ShowTime) AS CreateTime,

    FROM `{{ ads_joined_profiles }}` AS profiles
    WHERE
        IsRsya == True
        AND FraudBits == 0
        AND (
            SSPID > 10000
            OR UniqIDSource == 'duid'
            OR ShowTime - $get_main_ids_create_time(ProfileDump, ShowTime) < 24 * 60 * 60
        )
)

$parsed = (
    SELECT
        HitLogID,
        UniqID,
        BannerID,
        ShowTime,
        CAST(IsClick as int64) AS IsClick,
        IF(IsClick, RealCost, 0) AS RealCost,
        UdfFromParser::NomzodParserUser(ProfileDump ?? "", CAST(ShowTime AS Uint64)) AS User,
        UdfFromParser::NomzodParserBanner(BannerProfileNoTsar ?? "", CAST(ShowTime AS Uint64)) AS Banner,
        UdfFromParser::NomzodParserOrder(OrderProfile ?? "", CAST(ShowTime AS Uint64)) AS `Order`,
        UdfFromParser::NomzodParserAdGroup(AdGroupProfile ?? "", CAST(ShowTime AS Uint64)) AS AdGroup,
        UdfFromParser::NomzodParserPage(PageContextProto ?? "", CAST(ShowTime AS Uint64)) AS Page,
    FROM $proto_pool
);

INSERT INTO `{{ output_table }}`
WITH TRUNCATE

SELECT *
FROM $parsed
FLATTEN columns;
"""


def run(
    yql_client,
    ads_joined_profiles,
    output_log,
    is_logos_test=False,
):
    yql_client.execute(
        templater.render_template(
            filter_join_query,
            vars={
                'is_logos_test': is_logos_test,
                'output_log': output_log,
                'ads_joined_profiles': ads_joined_profiles,
            },
        ),
    )
