import os

from crypta.prism.lib.config import environment

if environment.ENVIRONMENT == 'production':
    from crypta.prism.lib.config.production_config import *  # noqa
    from crypta.prism.lib.config.production_config import (
        CRYPTA_YT_WORKING_DIR,
        OFFLINE_PRISM_DIRECTORY,
    )
else:
    from crypta.prism.lib.config.testing_config import *  # noqa
    from crypta.prism.lib.config.testing_config import (
        CRYPTA_YT_WORKING_DIR,
        OFFLINE_PRISM_DIRECTORY,
    )


BM_CATEGORIES_TO_TAKE = 1000
OPERATING_SYSTEMS_TO_TAKE = 5
MOBILE_MODELS_TO_TAKE = 50
REGIONS_TO_TAKE = 300
VALIDATION_SAMPLE_PERCENTAGE = 10
VALIDATION_SAMPLE_REST = 0
CONST_FOR_BIGB_WEIGHTS = int(1e6)
OFFLINE_WEIGHTING_OUTPUT_TTL_DAYS = 30
USER_WEIGHTS_BIGB_TTL_DAYS = 14
PRISM_LOOKALIKE_TTL_DAYS = 90
PRISM_LOOKALIKE_SAMPLE_TTL_DAYS = 7
FEATURES_AND_CLUSTER_BY_USER_TTL_DAYS = 365
CLUSTER_STATS_AGGREGATION_PERIOD_DAYS = 7
BIGB_PRISM_KEYWORD = 1042
BIGB_FLOAT_TO_UINT_MULT = 1000000  # One million.
BIGB_CLUSTER_MULT = 10000000  # Ten millions.
BIGB_UNKNOWN_CLUSTER_VALUE = 0  # For Unknown and -1
LAL_SAMPLE_TAXI_ULTIMA_TARIFFS = ('Cruise', 'Elite', 'Premier', 'Business')
LAL_SAMPLE_TAXI_MIN_BUSINESS_ORDER_RATIO = 0.3
LAL_SAMPLE_TAXI_MIN_ORDER_CNT = 10
MASTERCARD_WE_AUDIENCE_SEGMENT_ID = 13048771
VISA_INFINITE_AUDIENCE_SEGMENT_ID = 19619096
MAIN_SERP_ABC_ID = 1021
RSYA_ABC_ID = 36259
MIN_PRIOR_SIZE = 1000
PRIOR_SAMPLE_PERIOD_DAYS = 14
PRISM_SEGMENT_LOWER_CLUSTER_BOUNDS = [1, 8, 52, 92, 100]
DAYS_FOR_QUALITY_METRICS_COMPARISON = 14

BIGB_UDF_URL = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}'

COMMON_TMP_DIRECTORY = '//tmp'
COMMON_YQL_TMP_DIRECTORY = os.path.join(COMMON_TMP_DIRECTORY, 'yql')

PROFILES_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'profiles')
PROFILES_REALTIME_DIRECTORY = os.path.join(PROFILES_DIRECTORY, 'realtime')
REALTIME_PRISM_DIRECTORY = os.path.join(PROFILES_REALTIME_DIRECTORY, 'prism')
CRYPTA_PUBLIC_DIR = '//home/crypta/public'

BLENDER_RICHSEARCH = '//home/blender/richsearch'

# Realtime prism training
FEATURES_MAPPING_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'features_mapping')
RAW_TRAIN_SAMPLE_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'raw_train_sample')
CATBOOST_TRAIN_SAMPLE_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'catboost_train_sample')
CATBOOST_VAL_SAMPLE_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'catboost_val_sample')
CATBOOST_COLUMN_DESCRIPTION_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'pool.cd')
MODEL_FILE = os.path.join(REALTIME_PRISM_DIRECTORY, 'catboost_model.bin')
MODEL_PREDICTIONS_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'model_predictions')
DISTRIBUTION_FOR_THRESHOLDS_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'distribution_for_thresholds')
MODEL_PREDICTIONS_FOR_THRESHOLDS_TABLE = os.path.join(REALTIME_PRISM_DIRECTORY, 'model_predictions_for_thresholds')

PRISM_OFFLINE_USER_WEIGHTS_DIR = os.path.join(OFFLINE_PRISM_DIRECTORY, 'user_weights')
PRISM_CLUSTER_MAPPING_TABLE = os.path.join(BLENDER_RICHSEARCH, 'export/longterm_norm_segment_weights')
BEH_HIT_HOUR_LOG_DIR = '//logs/beh-profile-hit-log/1h'

YABS_DICT_DIR = '//home/yabs/dict'
BM_CATEGORIES_DESCRIPTION_TABLE = os.path.join(YABS_DICT_DIR, 'BMCategory')
OS_DESCRIPTION_TABLE = os.path.join(YABS_DICT_DIR, 'DetailedDeviceTypeDesc')

# Offline prism weighting
STATBOX_PRODUCT_MONEY_DIR = '//statbox/cube/daily/product_money/v1'
PROFILES_EXPORT_YT_DIRECTORY = os.path.join(PROFILES_DIRECTORY, 'export')
YANDEXUID_PROFILES_EXPORT_DIR = os.path.join(PROFILES_EXPORT_YT_DIRECTORY, 'yandexuid')
YANDEXUID_EXPORT_PROFILES_14_DAYS_TABLE = '//home/crypta/production/profiles/export/profiles_for_14days'  # need production table for elite cards sample in testing
TX_LAVKA_TABLE = os.path.join(CRYPTA_YT_WORKING_DIR, 'tx/data/lavka')
TAXI_USER_PROFILE_TABLE = '//home/taxi-dwh/export/crypta_user_profile/taxi_user_profile/taxi_user_profile'
ATNIFRAUD_EXPORT_BY_DATE_TABLE = '//home/antifraud/export/uid_types/daily/{}/uid_types'
USER_SESSIONS_PUB_DIR = '//user_sessions/pub'
USER_SESSIONS_NANO_BY_DATE_TABLE = os.path.join(USER_SESSIONS_PUB_DIR, 'nano_sessions/daily/{}/web/clean')
USER_SESSIONS_STAFF_BY_DATE_TABLE = os.path.join(USER_SESSIONS_PUB_DIR, 'yandex_staff/search/daily/{}.columns')
USER_SESSIONS_SEARCH_DAILY_DIR = os.path.join(USER_SESSIONS_PUB_DIR, 'search/daily')
USER_SESSIONS_CLEAN_BY_DATE_TABLE = os.path.join(USER_SESSIONS_SEARCH_DAILY_DIR, '{}/columns/clean')
USER_SESSIONS_FRAUDS_BY_DATE_TABLE = os.path.join(USER_SESSIONS_SEARCH_DAILY_DIR, '{}/columns/frauds')
LONGTERM_NORM_SEGMENT_WEIGHTS_TABLE = os.path.join(BLENDER_RICHSEARCH, 'longterm_norm_segment_weights/2021-01-01')
YUID_WITH_ALL_INFO_TABLE = os.path.join(CRYPTA_YT_WORKING_DIR, 'ids_storage/yandexuid/yuid_with_all_info')
INDEVICE_YANDEXUID_MATCHING_TABLE = os.path.join(PROFILES_DIRECTORY, 'matching/indevice_yandexuid')
MATCHING_BY_ID_DIR = os.path.join(CRYPTA_PUBLIC_DIR, 'matching/by_id')
MATCHING_BY_ID_YANDEXUID_DIR = os.path.join(MATCHING_BY_ID_DIR, 'yandexuid')
YANDEXUID_CRYPTAID_MATCHING_TABLE = os.path.join(MATCHING_BY_ID_YANDEXUID_DIR, 'crypta_id')
YANDEXUID_ICOOKIE_MATCHING_TABLE = os.path.join(MATCHING_BY_ID_YANDEXUID_DIR, 'direct/icookie')

CRYPTA_PRISM_DIR = os.path.join(CRYPTA_YT_WORKING_DIR, 'prism')
PRISM_LAL_SAMPLES_DIR = os.path.join(CRYPTA_PRISM_DIR, 'lookalike_samples')

PRISM_LAL_DIR = os.path.join(OFFLINE_PRISM_DIRECTORY, 'lookalike')
USER_WEIGHTS_BIGB_DIR = os.path.join(OFFLINE_PRISM_DIRECTORY, 'user_weights_bigb')
PRISM_PRIORS_DIR = os.path.join(OFFLINE_PRISM_DIRECTORY, 'priors')

OFFLINE_PRISM_TMP_DIR = os.path.join(OFFLINE_PRISM_DIRECTORY, 'tmp')
CLUSTER_STATS_DIR = os.path.join(OFFLINE_PRISM_TMP_DIR, 'cluster_stats')
CLUSTERS_DIR = os.path.join(OFFLINE_PRISM_TMP_DIR, 'clusters')
FRAUDS_DIR = os.path.join(OFFLINE_PRISM_TMP_DIR, 'frauds')
FEATURES_AND_CLUSTER_BY_USER_DIR = os.path.join(OFFLINE_PRISM_TMP_DIR, 'features_and_cluster_by_user')

# Offline prism metrics
USER_DATA_DIR = os.path.join(CRYPTA_YT_WORKING_DIR, 'lab/data')
YANDEXUID_USER_DATA_DIR = os.path.join(USER_DATA_DIR, 'daily')
CRYPTAID_USER_DATA_DIR = os.path.join(USER_DATA_DIR, 'crypta_id/daily')
DATALENS_OFFLINE_PRISM_DIR = os.path.join(CRYPTA_PRISM_DIR, 'datalens')
PRISM_PERFORMANCE_METRICS_TABLE = os.path.join(DATALENS_OFFLINE_PRISM_DIR, 'calculation_time')
PRISM_DAY_TO_DAY_CORRELATION_TABLE = os.path.join(DATALENS_OFFLINE_PRISM_DIR, 'day_to_day_correlation')
PRIORS_QUALITY_METRICS = os.path.join(DATALENS_OFFLINE_PRISM_DIR, 'priors_quality_metrics')

BS_CHEVENT_COOKED_LOG = '//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d'
MARKET_SALES_NO_EXTERNAL_FOLDER = '//home/market/production/analytics_platform/ecom_log_v2/sales_no_external'
MARKET_TAKERATE_TABLE = '//home/market/production/analytics_platform/analyst/takerate/takerate_by_beru_smoothed'
TRAFFIC_V3_DIR = '//statbox/cube/daily/traffic/v3'

PROFILES_YT_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'profiles')
CRYPTA_MONITORING_FOLDER = os.path.join(PROFILES_YT_DIRECTORY, 'monitorings')
CHEVENT_LOG_STATS_DIRECTORY = os.path.join(CRYPTA_MONITORING_FOLDER, 'chevent_log')
PRISM_MONITORING_DIRECTORY = os.path.join(CRYPTA_MONITORING_FOLDER, 'prism')
PRISM_CHEVENT_LOG_DIRECTORY = os.path.join(PRISM_MONITORING_DIRECTORY, 'chevent_log')
PRISM_GMV_DIRECTORY = os.path.join(PRISM_MONITORING_DIRECTORY, 'gmv')
PRISM_YANDEX_GOOGLE_VISITS_DIRECTORY = os.path.join(PRISM_MONITORING_DIRECTORY, 'yandex_google_visits')
PRISM_QUALITY_DIRECTORY = os.path.join(PRISM_MONITORING_DIRECTORY, 'quality')
DATALENS_PRISM_PRODUCTION_METRICS_TABLE = os.path.join(DATALENS_OFFLINE_PRISM_DIR, 'production_metrics')

# Realtime prism metrics
DATALENS_REALTIME_PRISM_DIR = os.path.join(REALTIME_PRISM_DIRECTORY, 'datalens')
DATALENS_REALTIME_PRISM_ROC_AUC_TABLE = os.path.join(DATALENS_REALTIME_PRISM_DIR, 'roc_auc')
DATALENS_REALTIME_PRISM_COUNTS_TABLE = os.path.join(DATALENS_REALTIME_PRISM_DIR, 'counts')
