#include "ads/bsyeti/libs/counter_lib/counter_packer/counter_packer.h"
#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/prism/lib/model/evaluate.h>
#include <crypta/prism/lib/model/test_utils/utils.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/yson/node/node_io.h>
#include <library/cpp/testing/benchmark/bench.h>
#include <util/stream/file.h>

#include <benchmark/benchmark.h>

using namespace NCrypta::NPrism;

namespace {
    const TModel& GetModel() {
        static const TModel model = NTestUtils::GetTestModel();
        return model;
    };

    const TVector<NBSYeti::TProfile>& GetProfiles() {
        static TVector<NBSYeti::TProfile> profiles;

        if (profiles.empty()) {
            const auto& rawInput = NResource::Find("/input.yson");
            TMemoryInput input(rawInput);

            const auto rows = NYT::NodeFromYsonStream(&input, NYson::EYsonType::ListFragment).UncheckedAsList();

            ::yabs::proto::Profile profile;
            for (const auto& row: rows) {
                NCrypta::NProtoSerializer::FromString(profile, row["ProfileDump"].AsString());
                profiles.push_back(NTestUtils::ConvertProfile(profile));
            }
        }

        return profiles;
    }

    void BM_Evaluate(benchmark::State& state) {
        const auto& model = GetModel();
        const auto& profiles = GetProfiles();
        ui64 i = 0;

        for (auto _ : state) {
            benchmark::DoNotOptimize(Evaluate(model, profiles.at(i % profiles.size())));
        }
    }
}

BENCHMARK(BM_Evaluate);

BENCHMARK_MAIN();
