#include "evaluate.h"

#include <crypta/lib/native/bigb_catboost_applier/catboost_features_calculator.h>

#include <google/protobuf/repeated_field.h>
#include <catboost/libs/model/model.h>

#include <library/cpp/iterator/zip.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/stream/file.h>
#include <util/string/join.h>

#include <algorithm>
#include <utility>

TMaybe<NCrypta::NPrism::TPrismResult> NCrypta::NPrism::Evaluate(const TModel& model, const NBSYeti::TProfile& profile) {
    const auto& result = TBigbCatboostApplier(model.CatboostFeaturesCalculator, profile).Apply(model.Model, model.Thresholds.GetThresholds());
    if (!result.Class.Defined()) {
        return Nothing();
    }

    const auto& bigCluster = *result.Class;
    const auto& clusterInfo = model.Clusters.GetClusters().at(bigCluster);

    return TPrismResult{
        .Weight = clusterInfo.GetWeight(),
        .BigCluster = static_cast<i64>(bigCluster) + 1,
        .SmallCluster = clusterInfo.GetSmallCluster() + 1,
    };
}
