#include "model.h"
#include "validate_model.h"

#include <crypta/lib/native/bigb_catboost_applier/proto/catboost_features_mapping.pb.h>

#include <catboost/libs/model/model.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/protobuf/json/json2proto.h>

#include <util/folder/path.h>
#include <util/generic/vector.h>
#include <util/stream/file.h>

NCrypta::NPrism::TModel NCrypta::NPrism::LoadModelFromFolder(const TString& folder) {
    const auto config = NProtobufJson::TJson2ProtoConfig().SetMapAsObject(true).SetCastFromString(true);

    TFileInput inFeatures(JoinFsPaths(folder, "features_mapping.json"));
    const auto& featuresMapping = NProtobufJson::Json2Proto<NCrypta::TCatboostFeaturesMapping>(inFeatures, config);

    TFileInput inThresholds(JoinFsPaths(folder, "thresholds.json"));
    auto thresholds = NProtobufJson::Json2Proto<TThresholds>(inThresholds, config);

    TFileInput inClusters(JoinFsPaths(folder, "clusters.json"));
    auto clusters = NProtobufJson::Json2Proto<TClusters>(inClusters, config);

    const auto& rawModelPath = JoinFsPaths(folder, "model.bin");
    auto fullModel = ReadModel(rawModelPath);

    TModel model{
        .Model = std::move(fullModel),
        .Thresholds = std::move(thresholds),
        .Clusters = std::move(clusters),
        .CatboostFeaturesCalculator = TCatboostFeaturesCalculator(
                {featuresMapping.GetFeatureToIndex().begin(), featuresMapping.GetFeatureToIndex().end()},
                {featuresMapping.GetCounterToPrefix().begin(), featuresMapping.GetCounterToPrefix().end()},
                {featuresMapping.GetKeywordToPrefix().begin(), featuresMapping.GetKeywordToPrefix().end()})
    };
    ValidateModel(model);
    return model;
}
