import logging

import crypta.lib.python.yql.client as yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.prism.lib.config import config


logger = logging.getLogger(__name__)


def get_yt_client(nv_params):
    return yt_helpers.get_yt_client(
        yt_proxy=nv_params['mr-default-cluster'],
        yt_pool=nv_params['yt-pool'],
        yt_token=nv_params['yt-token'],
        yt_prefix=config.REALTIME_PRISM_DIRECTORY + '/',
        acl=[
            {
                'subjects': ['crypta-team'],
                'action': 'allow',
                'permissions': ['manage', 'read'],
            },
        ],
        read_parallel={
            'max_thread_count': 20,
            'data_size_per_thread': 8 * 1024 * 1024,
            'enable': True,
        },
        remote_temp_tables_directory=config.COMMON_TMP_DIRECTORY,
    )


def get_yql_client(nv_params):
    return yql_helpers.create_yql_client(
        yt_proxy=nv_params['mr-default-cluster'],
        token=nv_params['yql-token'],
        pool=nv_params['yt-pool'],
        syntax_version=1,
        tmp_folder=config.COMMON_YQL_TMP_DIRECTORY,
    )


def make_text_output(output_file, text):
    with open(output_file, 'w') as f:
        f.write(text)
