#pragma once

#include <ads/bsyeti/libs/vinyl/hash.h>
#include <ads/bsyeti/libs/vinyl/string.h>

namespace NCrypta::NPrism::NPriorBase {
    template <class M>
    struct TPrior {
        ui64 SmallCluster;
        ui64 Count;
    };

    template <class M>
    using TPriorDictV1 = NVinyl::THashMap<M, NVinyl::TString<M>, TPrior<M>>;

    template <class M>
    struct TBaseV1 {
        static constexpr size_t VINYL_VERSION = 1u;

        TPriorDictV1<M> Data;
    };
}
