from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.prism.lib.config import config


performance_metrics_query = '''
$parse_datetime = DateTime::Parse('%Y-%m-%dT%H:%M:%SZ');
$parse_date = DateTime::Parse('%Y-%m-%d %Z');
$format_date = DateTime::Format('%Y-%m-%d');
$natural_lag = DateTime::IntervalFromDays(1);

$get_interval = ($x, $y) -> {
    RETURN DateTime::IntervalFromSeconds(
        CAST(DateTime::ToSeconds($x) AS Int32) - CAST(DateTime::ToSeconds($y) AS Int32)
    );
};

$get_date = ($path) -> {
    RETURN ListLast(String::SplitToList($path, '/'));
};

DEFINE SUBQUERY $get_folder_info($folder) AS
   SELECT
        $get_date(Path) AS dt,
        $parse_datetime(Yson::ConvertToString(Attributes['modification_time'])) AS finish_time,
        $parse_date($get_date(Path) || ' Europe/Moscow') AS start_time,
    FROM FOLDER($folder, 'modification_time')
END DEFINE;

$user_weights = PROCESS $get_folder_info('{{ prism_user_weights_dir }}');

$profiles = PROCESS $get_folder_info('{{ yandexuid_profiles_export_dir }}');

$lals = (
    PROCESS $get_folder_info('{{ lookalike_dir }}')
);

$user_data = (
    PROCESS $get_folder_info('{{ yandexuid_user_data_dir }}')
    UNION ALL
    PROCESS $get_folder_info('{{ crypta_id_user_data_dir }}')
);

$user_data = (
    SELECT
        $format_date(SOME(start_time - $natural_lag)) AS dt,
        SOME(start_time) AS start_time,
        MAX(finish_time) AS finish_time,
    FROM $user_data
    GROUP BY dt
);

INSERT INTO `{{ performance_metrics }}`
SELECT
    user_weights.dt AS dt,
    CAST(DateTime::ToSeconds($get_interval(user_weights.finish_time, user_weights.start_time) - $natural_lag) AS Double) / 60 / 60 AS prism,
    CAST(DateTime::ToSeconds($get_interval(yandexuid.finish_time, yandexuid.start_time) - $natural_lag) AS Double) / 60 / 60 AS profiles_export,
    CAST(DateTime::ToSeconds($get_interval(lals.finish_time, lals.start_time) - $natural_lag) AS Double) / 60 / 60 AS lals,
    CAST(DateTime::ToSeconds($get_interval(user_data.finish_time, user_data.start_time)) AS Double) / 60 / 60 AS user_data,
FROM $user_weights AS user_weights
LEFT JOIN ANY $profiles AS yandexuid
ON user_weights.dt == yandexuid.dt
LEFT JOIN ANY $lals AS lals
ON user_weights.dt == lals.dt
LEFT JOIN ANY $user_data AS user_data
ON user_weights.dt == user_data.dt
WHERE user_weights.dt == '{{ date }}'
ORDER BY dt;
'''


def update(
    yt_client,
    yql_client,
    date,
    prism_user_weights_dir=config.PRISM_OFFLINE_USER_WEIGHTS_DIR,
    yandexuid_profiles_export_dir=config.YANDEXUID_PROFILES_EXPORT_DIR,
    lookalike_dir=config.PRISM_LAL_DIR,
    yandexuid_user_data_dir=config.YANDEXUID_USER_DATA_DIR,
    crypta_id_user_data_dir=config.CRYPTAID_USER_DATA_DIR,
    performance_metrics_output=config.PRISM_PERFORMANCE_METRICS_TABLE,
):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            templater.render_template(
                performance_metrics_query,
                vars={
                    'prism_user_weights_dir': prism_user_weights_dir,
                    'yandexuid_profiles_export_dir': yandexuid_profiles_export_dir,
                    'lookalike_dir': lookalike_dir,
                    'yandexuid_user_data_dir': yandexuid_user_data_dir,
                    'crypta_id_user_data_dir': crypta_id_user_data_dir,
                    'performance_metrics': performance_metrics_output,
                    'date': date,
                },
            ),
            title='YQL Prism calculate clusters',
            transaction=str(transaction.transaction_id),
        )
