import os

from crypta.prism.lib.config import config


def custom_lookalike_samples_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'lookalike_samples', date)


def custom_lookalike_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'lookalike', date)


def custom_clusters_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'clusters', date)


def custom_frauds_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'frauds', date)


def custom_cluster_stats_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'cluster_stats', date)


def custom_user_weights_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'user_weights', date)


def custom_user_weights_bigb_table(custom_output_dir, date):
    return None if custom_output_dir is None else os.path.join(custom_output_dir, 'user_weights_bigb', date)


def resolve(custom_output_dir, date):
    return {
        'cluster_stats': custom_cluster_stats_table(custom_output_dir, date) or os.path.join(config.CLUSTER_STATS_DIR, date),
        'clusters': custom_clusters_table(custom_output_dir, date) or os.path.join(config.CLUSTERS_DIR, date),
        'frauds': custom_frauds_table(custom_output_dir, date) or os.path.join(config.FRAUDS_DIR, date),
        'lookalike': custom_lookalike_table(custom_output_dir, date) or os.path.join(config.PRISM_LAL_DIR, date),
        'lookalike_samples': custom_lookalike_samples_table(custom_output_dir, date) or os.path.join(config.PRISM_LAL_SAMPLES_DIR, date),
        'user_weights': custom_user_weights_table(custom_output_dir, date) or os.path.join(config.PRISM_OFFLINE_USER_WEIGHTS_DIR, date),
        'user_weights_bigb': custom_user_weights_bigb_table(custom_output_dir, date) or os.path.join(config.USER_WEIGHTS_BIGB_DIR, date),
    }
