#!/usr/bin/env python
# -*- coding: utf-8 -*-

import functools
import logging

from crypta.lib.python.logging import logging_helpers
from crypta.prism.lib.nirvana import utils
from crypta.prism.services.priors.lib import (
    features_and_cluster_by_user,
    priors,
    quality_metrics,
)


import nirvana.job_context as nv

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stderr_logger(logging.getLogger(), level=logging.INFO)
    logger.info('Prism priors')

    context = nv.context()

    parameters = context.get_parameters()
    date = parameters.get('date')
    yt_client = utils.get_yt_client(nv_params=parameters)
    yql_client = utils.get_yql_client(nv_params=parameters)

    tasks_dict = {
        'features_to_cluster_calculate': functools.partial(
            features_and_cluster_by_user.calculate,
            yt_client=yt_client,
            yql_client=yql_client,
            date=date,
        ),
        'priors_calculate': functools.partial(
            priors.calculate,
            yt_client=yt_client,
            yql_client=yql_client,
            date=date,
        ),
        'send_correlation_metrics': functools.partial(
            quality_metrics.send_correlation_metrics,
            yt_client=yt_client,
            yql_client=yql_client,
            date=date,
        ),
    }

    job_name = parameters.get('job_name')
    logger.info('Job name: {}'.format(job_name))

    if job_name in tasks_dict:
        tasks_dict[job_name]()
    else:
        logger.warn('Unknown job_name "{}"'.format(job_name))
        exit(1)


if __name__ == '__main__':
    main()
