import logging

from google.protobuf import json_format

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.prism.lib.config import config
from crypta.prism.proto.clusters_pb2 import TClusters
from crypta.prism.services.training.lib import utils


logger = logging.getLogger(__name__)


def match(yt_client, output):
    with NirvanaTransaction(yt_client):
        clusters_proto = TClusters()
        for row in yt_client.read_table(config.PRISM_CLUSTER_MAPPING_TABLE):
            prism_segment = row['prism_segment']
            ind = utils.PRISM_SEGMENT_TARGET_MAPPING[prism_segment]
            cluster = int(row['cluster'])
            assert cluster in utils.PRISM_SEGMENT_CLUSTER_RANGE[prism_segment], \
                'Cluster {} is not in range of prism segment {}'.format(cluster, prism_segment)

            # https://a.yandex-team.ru/arc/trunk/arcadia/crypta/prism/lib/model/evaluate.cpp#L29 - as there +1, here should be -1
            clusters_proto.Clusters[ind].SmallCluster = cluster - 1

            clusters_proto.Clusters[ind].Weight = int(config.CONST_FOR_BIGB_WEIGHTS * row['norm_serp_revenue'])

        with open(output, 'w') as output_file:
            output_file.write(json_format.MessageToJson(clusters_proto, sort_keys=True))
