import logging

from google.protobuf import json_format

from crypta.lib.python.bigb_catboost_applier import features_mapping as feature_mapping_utils
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.prism.lib.config import config
from crypta.prism.services.training.lib import utils


logger = logging.getLogger(__name__)


def compute(yt_client, yql_client, output):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=feature_mapping_utils.compute_features_mapping_query.format(
                bm_categories_to_take=config.BM_CATEGORIES_TO_TAKE,
                operating_systems_to_take=config.OPERATING_SYSTEMS_TO_TAKE,
                mobile_models_to_take=config.MOBILE_MODELS_TO_TAKE,
                regions_to_take=config.REGIONS_TO_TAKE,
                train_sample_table=config.RAW_TRAIN_SAMPLE_TABLE,
                bm_categories_description_table=config.BM_CATEGORIES_DESCRIPTION_TABLE,
                os_description_table=config.OS_DESCRIPTION_TABLE,
                output_table=config.FEATURES_MAPPING_TABLE,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL get realtime prism features_mapping',
        )

        logger.info('Computed features_mapping')

        with open(output, 'w') as output_file:
            output_file.write(json_format.MessageToJson(
                feature_mapping_utils.get_proto_features_mapping(
                    yt_client=yt_client,
                    features_mapping_table_path=config.FEATURES_MAPPING_TABLE,
                    counters_to_features=utils.COUNTERS_TO_FEATURES,
                    keywords_to_features=utils.KEYWORDS_TO_FEATURES,
                ),
                sort_keys=True,
            ))

        logger.info('Successfully dumped features mapping')
