#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.prism.lib.config import config


logger = logging.getLogger(__name__)


def get(yt_client, json_input, date):
    with NirvanaTransaction(yt_client):
        with open(json_input, 'r') as training_log_file:
            training_log = json.load(training_log_file)

        roc_auc = max(training_log['iterations'], key=lambda elem: elem['test'][1])['test'][1]
        yt_helpers.write_stats_to_yt(
            yt_client=yt_client,
            table_path=config.DATALENS_REALTIME_PRISM_ROC_AUC_TABLE,
            data_to_write={
                'roc_auc': roc_auc,
            },
            schema={
                'roc_auc': 'double',
            },
            date=date,
        )
