#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import Mapping


class FrozenDict(Mapping):
    def __init__(self, *args, **kwargs):
        self._d = dict(*args, **kwargs)
        self._hash = None

    def __iter__(self):
        return iter(self._d)

    def __len__(self):
        return len(self._d)

    def __getitem__(self, key):
        return self._d[key]

    def __repr__(self):
        return '{} {} with {} elements'.format(
            self.__class__.__name__,
            hex(self.__hash__() % (1 << 64)),  # unsigned int64 value
            len(self._d)
        )

    def __hash__(self):
        if self._hash is None:
            self._hash = 0
            for pair in self.iteritems():
                if isinstance(pair[1], set):
                    pair = (pair[0], frozenset(pair[1]))
                elif isinstance(pair[1], dict):
                    pair = (pair[0], FrozenDict(pair[1]))
                elif isinstance(pair[1], list):
                    pair = (pair[0], tuple(pair[1]))
                self._hash ^= hash(pair)
        return self._hash
