#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

import pandas as pd


def read_into_pandas_dataframe(yt, path):
    return pd.DataFrame(list(yt.read_table(path)))


def write_pandas_dataframe(yt, path, df, columns=None):
    if columns is not None:
        df = df[columns]

    yt.create_directory(os.path.dirname(path))
    yt.write_table(path, (row.to_dict() for _, row in df.iterrows()))
