import numpy as np

ACTIVATION_FUNCTIONS = {
    'relu': lambda x: np.maximum(x, 0),
    'sigmoid': lambda x: 1 / (1 + np.exp(-x)),
    'softmax': lambda x: np.exp(x) / (np.exp(x).sum(axis=1)[:, None]),
}


class SimpleNN(object):
    """Wrapper for simple keras neural networks

    Accepts list of layers: [((W, b), 'relu'), ((W, b), 'sigmoid'), ...]
    """

    def __init__(self, layers):
        self.layers = layers

    def predict(self, X, env='production'):
        for weights, activation in self.layers:
            W, b = weights
            if env == 'production':
                X = ACTIVATION_FUNCTIONS[activation](X.dot(W) + b)
            else:
                X = ACTIVATION_FUNCTIONS[activation](X.astype(np.float16).dot(W.astype(np.float16)) + b)

        return X
