from crypta.profile.lib.socdem_helpers.socdem_config.features_white_lists import heuristic_common_white_list # noqa

VECTOR_SIZE = 512
SOCDEM_OFFSET = 13
MAX_SAMPLE_SIZE_TO_TRAIN_NN_MODEL = int(5e6)
INCOME_SAMPLING_SIZE = int(6e5)
ADDITIONAL_FEATURES_COLUMN = 'additional_features'
SOLOMON_PROJECT = 'crypta-ml'
SOLOMON_SERVICE = 'socdem_models_training'

# categorical features config
TOP_HOSTS_NUMBER = 500
MOBILE_FEATURES_NUMBERS = {
    'model': 45,
    'manufacturer': 4,
    'main_region_obl': 8,
}

SOCDEM_TYPES = ('gender', 'age', 'income')
SOCDEM_SEGMENT_TYPES = ('gender', 'age_segment', 'income_segment')
SOCDEM_SEGMENT_TYPE_NAMES = ('gender', 'user_age_6s', 'income_5_segments')
EXACT_SOCDEM_FIELDS = ('gender', 'age_segment', 'income_5_segment')

segment_names_by_label_type = {
    'gender': ['m', 'f'],
    'age_segment': ['0_17', '18_24', '25_34', '35_44', '45_54', '55_99'],
    'income_segment': ['A', 'B1', 'B2', 'C1', 'C2'],
}

yet_another_segment_names_by_label_type = {
    'gender': ['m', 'f'],
    'user_age_6s': ['0_17', '18_24', '25_34', '35_44', '45_54', '55_99'],
    'income_5_segments': ['A', 'B1', 'B2', 'C1', 'C2'],
}

socdem_type_to_segment_name = {
    'gender': 'gender',
    'age': 'age_segment',
    'income': 'income_segment',
}

socdem_type_to_yet_another_segment_name = {
    'gender': 'gender',
    'age': 'user_age_6s',
    'income': 'income_5_segments',
}

needed_recalls = {
    'gender': [0.48, 0.52],
    'user_age_6s': [0.08, 0.11, 0.26, 0.22, 0.15, 0.18],
    'income_5_segments': [0.08, 0.38, 0.38, 0.15, 0.01],
}

needed_total_recalls = {
    'gender': 0.92,
    'user_age_6s': 0.91,
    'income_5_segments': 0.95,
}
