import numpy as np

from crypta.profile.lib.socdem_helpers import socdem_config
from crypta.profile.lib.socdem_helpers.simple_nn import SimpleNN


def convert_simple_keras_to_numpy(nn):
    layers = []
    for layer in nn.layers:
        if layer.__class__.__name__ == 'Dense':
            layers.append((layer.get_weights(), layer.activation.__name__))
    return SimpleNN(layers)


def get_custom_neuro_model(n_classes, neuro_offset=socdem_config.VECTOR_SIZE, random_seed=None):
    from tensorflow.keras.models import Sequential
    from tensorflow.keras.layers import Dense, Dropout
    from tensorflow import set_random_seed

    if random_seed is not None:
        np.random.seed(random_seed)
        set_random_seed(random_seed)

    model = Sequential([
        Dense(256, input_dim=neuro_offset, activation='relu'),
        Dropout(0.25),
        Dense(128, activation='relu'),
        Dropout(0.25),
        Dense(n_classes, activation='softmax'),
    ])
    model.compile(optimizer='adam', loss='categorical_crossentropy')

    return model
