#!/usr/bin/env python
# -*- coding: utf-8 -*-
import numpy as np
from yt.yson import get_bytes


def normalize(x):
    return x / np.sqrt(np.dot(x, x))


def binary_to_numpy(vector):
    vector = get_bytes(vector)
    return np.fromstring(vector, '<f4')


def vector_to_features(vector):
    return normalize(binary_to_numpy(vector))


def vector_row_to_features(row):
    return vector_to_features(row['vector'])


def sum_vectors_reducer(key, rows):
    row = next(rows)
    resulting_vector = binary_to_numpy(row['vector'])

    for row in rows:
        resulting_vector += binary_to_numpy(row['vector'])

    output_row = dict(key)
    output_row['vector'] = resulting_vector.tostring()
    yield output_row
