#!/usr/bin/env python
# -*- coding: utf-8 -*-
import luigi

from crypta.profile.runners.export_profiles.lib.affinity.host_affinity import PrecalculateHostsAffinity
from crypta.profile.runners.export_profiles.lib.affinity.prepare_words import PrecalculateReqansWordsAffinity


class PrecalculateAffinity(luigi.WrapperTask):
    task_group = 'precalculate_affinity'
    date = luigi.Parameter()

    def requires(self):
        return {
            'reqans_words_affinity': PrecalculateReqansWordsAffinity(self.date),

            'yandexuid_hosts_affinity': PrecalculateHostsAffinity(self.date, 'yandexuid'),
            'crypta_id_hosts_affinity': PrecalculateHostsAffinity(self.date, 'crypta_id'),
        }
