#!/usr/bin/python -tt
# -*- coding: utf-8 -*-

import os

import luigi

from crypta.lib.python.juggler import juggler_helpers
from crypta.profile.lib import date_helpers
from crypta.profile.runners.export_profiles.lib.export.upload_audience_segments_to_api import UploadAudienceSegmentsToApi
from crypta.profile.utils.api import get_api
from crypta.profile.utils.config import config
from crypta.profile.utils import luigi_utils


query = """
$not_ok_segments = (
    SELECT segment_id
    FROM `{yandexuid_segments_directory}/{yesterday_date}`
    WHERE status != 'ok'
    UNION ALL
    SELECT segment_id
    FROM `{crypta_id_segments_directory}/{yesterday_date}`
    WHERE status != 'ok'
);


INSERT INTO `{output_table}` WITH TRUNCATE
SELECT segment_id
FROM `{yandexuid_segments_directory}/{today_date}`
WHERE status != 'ok' AND segment_id IN $not_ok_segments
UNION ALL
SELECT segment_id
FROM `{crypta_id_segments_directory}/{today_date}`
WHERE status != 'ok' AND segment_id IN $not_ok_segments
"""


class CheckAudienceUpload(luigi_utils.BaseYtTask):
    date = luigi.Parameter()
    task_group = 'monitoring'

    def requires(self):
        return {
            'yandexuid': UploadAudienceSegmentsToApi(date=self.date, data_source='yandexuid'),
            'crypta_id': UploadAudienceSegmentsToApi(date=self.date, data_source='crypta_id'),
        }

    def output(self):
        return {
            'yandexuid': luigi_utils.YtTableAttributeTarget(self.input()['yandexuid'].table, 'checked', True),
            'crypta_id': luigi_utils.YtTableAttributeTarget(self.input()['crypta_id'].table, 'checked', True),
        }

    @staticmethod
    def get_active_audience_exports():
        api = get_api()

        active_audience_segments = []

        for segment in api.lab.getAllSegments().result():
            for export in segment.exports.exports:
                if export.keywordId == 557 and export.state not in ('DISABLED', 'DELETED', 'CREATED'):
                    active_audience_segments.append(export.segmentId)

        return active_audience_segments

    def run(self):
        with self.yt.Transaction() as transaction, \
                self.yt.TempTable() as not_ok_segments_table:
            self.yql.query(
                query.format(
                    yandexuid_segments_directory=os.path.dirname(self.input()['yandexuid'].table),
                    crypta_id_segments_directory=os.path.dirname(self.input()['crypta_id'].table),
                    today_date=self.date,
                    yesterday_date=date_helpers.get_yesterday(self.date),
                    output_table=not_ok_segments_table,
                ),
                transaction=transaction,
            )

            not_ok_segment_ids = [
                record['segment_id']
                for record in self.yt.read_table(not_ok_segments_table)
            ]

            active_audience_segments = set(self.get_active_audience_exports())
            not_ok_segment_ids = set(not_ok_segment_ids).intersection(active_audience_segments)

            if not_ok_segment_ids:
                juggler_helpers.report_event_to_juggler(
                    status='WARN',
                    service='audience_api_upload',
                    host=config.CRYPTA_PROFILE_JUGGLER_HOST,
                    description='Error uploading audience segments: {}. '.format(', '.join([str(segment_id) for segment_id in not_ok_segment_ids])),
                    logger=self.logger,
                )
            else:
                juggler_helpers.report_event_to_juggler(
                    status='OK',
                    service='audience_api_upload',
                    host=config.CRYPTA_PROFILE_JUGGLER_HOST,
                    logger=self.logger,
                )

            for output_target in self.output().values():
                self.yt.set_attribute(output_target.table, 'checked', True)
