# -*- coding: utf-8 -*-

import luigi

from crypta.profile.utils.api import get_api
from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import BaseYtTask, YtDailyRewritableTarget


class UploadLabSegmentsInfoToYt(BaseYtTask):
    date = luigi.Parameter()
    task_group = 'export_profiles'

    def output(self):
        return YtDailyRewritableTarget(
            config.LAB_SEGMENTS_INFO_TABLE,
            self.date,
        )

    def run(self):
        with self.yt.Transaction():
            self.yt.create_empty_table(
                self.output().table,
                schema={
                    'id': 'string',
                    'parentId': 'string',
                    'name': 'string',
                    'description': 'string',
                    'priority': 'int64',
                    'scope': 'string',
                    'type': 'string',
                    'tickets': 'any',
                    'author': 'string',
                    'responsibles': 'any',
                    'stakeholders': 'any',
                    'exportId': 'string',
                    'exportType': 'string',
                    'exportState': 'string',
                    'exportSegmentId': 'int64',
                    'exportKeywordId': 'int64',
                    'exportProfilesCoverageValue': 'int64',
                    'exportProfilesCoverageTimestamp': 'int64',
                    'exportBigbCoverageValue': 'int64',
                    'exportBigbCoverageTimestamp': 'int64',
                    'exportTags': 'any',
                },
            )
            self.yt.write_table(
                self.output().table,
                self._yield_lab_segments_info(),
            )
            self.yt.run_sort(
                self.output().table,
                sort_by='id',
            )
            self.yt.set_attribute(
                self.output().table,
                'generate_date',
                self.date,
            )

    @staticmethod
    def _yield_lab_segments_info():
        for segment_group in get_api().lab.getAllSegmentGroups().result():
            if segment_group.id.startswith('group-'):
                yield {
                    'id': segment_group.id,
                    'parentId': segment_group.parentId,
                    'author': segment_group.author,
                    'name': segment_group.name,
                    'description': segment_group.description,
                    'priority': segment_group.priority,
                }

        for segment in get_api().lab.getAllSegments().result():
            for segment_export in segment.exports.exports:
                yield {
                    'id': segment.id,
                    'parentId': segment.parentId,
                    'name': segment.name,
                    'description': segment.description,
                    'priority': segment.priority,
                    'scope': segment.scope,
                    'type': segment.type,
                    'tickets': segment.tickets,
                    'author': segment.author,
                    'responsibles': segment.responsibles,
                    'stakeholders': segment.stakeholders,
                    'exportId': segment_export.id,
                    'exportType': segment_export.type,
                    'exportState': segment_export.state,
                    'exportSegmentId': segment_export.segmentId,
                    'exportKeywordId': segment_export.keywordId,
                    'exportProfilesCoverageValue': segment_export.coverages.profiles.value,
                    'exportProfilesCoverageTimestamp': segment_export.coverages.profiles.timestamp,
                    'exportBigbCoverageValue': segment_export.coverages.bigb.value,
                    'exportBigbCoverageTimestamp': segment_export.coverages.bigb.timestamp,
                    'exportTags': segment_export.tags,
                }
