#!/usr/bin/python -tt
# -*- coding: utf-8 -*-
import os

import luigi

from crypta.lib.python.yt import yt_helpers
from crypta.profile.utils.config import config
from crypta.profile.utils.config.secrets import get_secrets
from crypta.profile.utils.loggers import TimeTracker
from crypta.profile.utils.luigi_utils import BaseYtTask, YtTarget, OldNodesByNameCleaner
from crypta.profile.utils.yt_to_logbroker import upload_to_logbroker

from crypta.profile.runners.export_profiles.lib.export.get_logbroker_export_table import (
    GetCryptaIdExportTables,
    GetExportTables,
)


class UploadProfilesToLogbroker(BaseYtTask):
    date = luigi.Parameter()
    id_type = luigi.Parameter()

    priority = 100
    task_group = 'export_profiles'

    def requires(self):
        requires_by_id_type = {
            'yandexuid': GetExportTables(self.date),
            'crypta_id': GetCryptaIdExportTables(self.date),
        }

        dir_to_clean = {
            'yandexuid': config.YANDEXUID_PROFILES_LOGS_DIRECTORY,
            'crypta_id': config.CRYPTA_ID_PROFILES_LOGS_DIRECTORY,
        }

        return {
            'Export': requires_by_id_type[self.id_type],
            'Cleaner': OldNodesByNameCleaner(
                self.date,
                folder=dir_to_clean[self.id_type],
                lifetime=config.NUMBER_OF_INTERMEDIATE_PROFILES_TABLES_TO_KEEP,
            ),
        }

    def output(self):
        output_by_id_type = {
            'yandexuid': YtTarget(os.path.join(config.YANDEXUID_PROFILES_LOGS_DIRECTORY, self.date)),
            'crypta_id': YtTarget(os.path.join(config.CRYPTA_ID_PROFILES_LOGS_DIRECTORY, self.date)),
        }

        return output_by_id_type[self.id_type]

    def run(self):
        with TimeTracker('{}_{}'.format(self.__class__.__name__, self.id_type)), \
                self.yt.Transaction(), \
                self.yt.TempTable() as profiles_table:

            if config.environment == 'production':
                self.yt.run_merge(
                    self.input()['Export'].table,
                    profiles_table,
                    mode='unordered',
                )
            else:
                yt_helpers.make_sample_with_rate(
                    self.yt,
                    self.input()['Export'].table,
                    profiles_table,
                    config.LOGBROKER_TESTING_SAMPLING_RATE,
                )

            upload_to_logbroker(
                profiles_table,
                self.output().table,
                logbroker_topic=config.CRYPTA_PROFILES_TOPIC_NAME,
                tvm_id=config.CRYPTA_PROFILE_TVM_ID,
                tvm_secret=get_secrets().get_secret('CRYPTA_PROFILE_TVM_SECRET') or '',
                n_partitions=config.LOGBROKER_PROFILES_JSON_LOG_PARTITIONS_NUMBER,
            )
