#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Crypta user profile interests processor

Usage:
  main.py interests_log_processors_task [--log-file-path=<path>]
  main.py interests_tasks [--log-file-path=<path>]
  main.py upload_shortterm_interests [--log-file-path=<path>]
  main.py (-h | --help)

Options:
  interests_log_processors_task Summon dragons and cast fireballs
  interests_tasks               Summon dragons and cast fireballs
  upload_shortterm_interests    Summon dragons and cast fireballs
  --log-file-path=<path>        Path for logs
"""

import time

import luigi
from docopt import docopt

from crypta.profile.lib import luigi_helpers
from crypta.profile.runners.interests.lib.runner import InterestsTasks, InterestsLogProcessorsTask
from crypta.profile.runners.interests.lib.upload_shortterm_interests import UploadTask
from crypta.profile.utils.config import config


def main():
    arguments = docopt(__doc__)

    if arguments['--log-file-path']:
        config.LOCAL_LOGS_DIRECTORY = config.TASKS_LOGS_DIRECTORY = arguments['--log-file-path']
        config.LOCAL_STORAGE_DIRECTORY = config.TIMESTAMP_TASKS_LOGS_DIRECTORY = arguments['--log-file-path']

    config.DEFAULT_POOL = config.INTERESTS_POOL

    luigi_helpers.setup_external_tasks_retry()

    task = None
    luigi_arguments = [
        '--scheduler-url', config.LUIGI_SCHEDULER_URL,
        '--log-level', 'INFO',
    ]
    if arguments['interests_log_processors_task']:
        task = InterestsLogProcessorsTask
        luigi_arguments += ['--workers', '4']

    elif arguments['interests_tasks']:
        task = InterestsTasks
        luigi_arguments += ['--workers', '4']

    elif arguments['upload_shortterm_interests']:
        task = UploadTask
        luigi_arguments += ['--workers', '1', '--timestamp', str(int(time.time()))]

    luigi.run(
        luigi_arguments,
        main_task_cls=task
    )


if __name__ == '__main__':
    main()
