#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.segment_utils import word_filter as sg

metrics_counter_url_to_interests_mapping = {
    'data_type': 'counter_url',
    'data_source': 'metrics',
    'mapping': [
        {
            'segment_id': 'segment-2324b3a4',  # Жилая недвижимость в новостройках
            'data': {
                2119876: ['newFlat=YES', 'novostrojka'],  # ya
                5284120: ['novostrojki', 'novostroyki'],  # cian
                1438381: ['novostroiki', 'ApartmentSaleType=New'],  # domofond
                23344858: ['novostroyki'],  # mirkvartir
            },
        },
    ]
}

metrics_title_lemmas_to_interests_mapping = {
    'data_type': 'lemmas',
    'data_source': 'metrics',
    'mapping': [
        {
            'segment_id': 'segment-healthy_eating',
            'data':
                sg.Or(
                    sg.And(
                        sg.Any('питание'),
                        sg.Any('здоровый', 'правильный', 'похудение', 'схема', 'рацион', 'программа'),
                    ),
                    sg.Any('калория', 'калорийность', 'диета'),
                )
        },
        {
            'segment_id': 'segment-payment_technologies',
            'data':
                sg.Or(
                    sg.Any('webmoney', 'вебмани', 'paypal', 'qiwi'),
                    sg.All('киви', 'кошелек'),
                    sg.All('яндекс', 'кошелек'),
                    sg.All('яндекс', 'деньги'),
                    sg.All('qiwi', 'кошелек'),
                    sg.All('qiwi', 'wallet'),
                    sg.All('pal', 'pay'),
                    sg.And(sg.Any('перевод'), sg.Any('карта', 'деньги')),
                )
        },
        {
            'segment_id': 'segment-mobile_games',
            'data':
                sg.And(
                    sg.Any('скачать', 'купить', 'загрузить', 'прохождение'),
                    sg.Any('игра', 'стратегия', 'шутер', 'гонка', 'game'),
                    sg.Any('андроид', 'телефон', 'айфон', 'android', 'iphone', 'мобильный'),
                )
        },
    ]
}


metrics_hosts_to_interests_mapping = {
    'data_type': 'hosts',
    'data_source': 'metrics',
    'mapping': [
        {
            'segment_id': 'segment-online_banking',
            'data': [
                'sberbank.ru', 'tinkoff.ru', 'alfabank.ru', 'tochka.com', 'citibank', 'vtb.ru', 'rocketbank.ru',
                'vostbank.ru', 'binbank.ru', 'sovcombank.ru', 'raiffeisen.ru', 'open.ru', 'psbank.ru', 'pochtabank.ru',
                'rusfinancebank.ru', 'rshb.ru', 'rsb.ru', 'rencredit.ru', 'rosbank.ru', 'mtsbank.ru', 'ubrr.ru',
                'modulbank.ru', 'bspb.ru', 'db.com'
            ]
        },
        {
            'segment_id': 'segment-payment_technologies',
            'data': [
                'qiwi.com',
                'money.yandex.ru',
                'paypal.com',
                'payment.mts.ru'
                'webmoney.ru'
            ],
        },
    ]
}
