#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
from os.path import basename

import luigi

from crypta.profile.runners.export_profiles.lib.export import get_logbroker_export_table
from crypta.profile.utils.config import config
from crypta.profile.utils.yt_utils import get_yt_client


class UploadTask(luigi.WrapperTask):
    timestamp = luigi.Parameter()

    def requires(self):
        self.yt = get_yt_client()
        for yt_object in self.yt.search(config.SHORTTERM_INTERESTS_INPUT_YT_DIRECTORY):
            if self.yt.get_attribute(yt_object, 'type') == 'table' and not self.yt.get_attribute(yt_object, 'locks'):
                table = yt_object
                return get_logbroker_export_table.GetShorttermInterestsExportTables(timestamp=basename(table))


if __name__ == '__main__':
    luigi.run(
        [
            '--scheduler-url', config.LUIGI_SCHEDULER_URL,
            '--workers', '1',
            '--timestamp', str(int(time.time())),
        ],
        main_task_cls=UploadTask
    )
