#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LalSampleBuilder,
    LaLParams,
)


afisha_users_query_template = """
$yandexuid_afisha_users = (
    SELECT
        CAST(yuid AS Uint64) AS yandexuid,
        'afisha_users' AS segment_name
    FROM `{input_table}`
    WHERE CAST(yuid AS Uint64) IS NOT NULL AND action_type == 'ticket.purchase.approved'
);

$other_id_afisha_users = (
    SELECT
        matching.yandexuid AS yandexuid,
        afisha_users.segment_name AS segment_name
    FROM (
        SELECT
            CAST(puid AS String) AS id,
            'puid' AS id_type,
            'afisha_users' AS segment_name
        FROM `{input_table}`
        WHERE puid IS NOT NULL AND puid != 0 AND action_type == 'ticket.purchase.approved'
    ) AS afisha_users
    INNER JOIN `{indevice_yandexuid_matching}` AS matching
    USING (id, id_type)
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT *
FROM (
    SELECT *
    FROM $yandexuid_afisha_users
    UNION ALL
    SELECT *
    FROM $other_id_afisha_users
)
GROUP BY yandexuid, segment_name
"""


class AfishaUsers(LalSampleBuilder):
    def requires(self):
        return ExternalInput(config.AFISHA_TICKET_ORDER_LOG)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=afisha_users_query_template.format(
                input_table=inputs.table,
                indevice_yandexuid_matching=config.INDEVICE_YANDEXUID,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )

        self.yt.set_attribute(
            output_path,
            'generate_date',
            self.date
        )

        self.prepare_samples_for_lal(
            input_table=output_path,
            id_field='yandexuid',
            lals_params=[LaLParams(
                name='afisha_users',
                id=1222,
                type='lal_internal',
                coverage=5000000,
                include_input=False,
            )],
        )
