#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    LalSampleBuilder
)


query_template = u"""
$designers_puids = (
    SELECT
        puid AS id,
        'puid' AS id_type
    FROM `{input_table}`
    WHERE
        is_published AND ListHas(specializations, '/dizajneryi/dizajner-intererov')
);

INSERT INTO `{output_table}`
WITH TRUNCATE
SELECT DISTINCT
    matching.yandexuid AS yandexuid,
    'interior_designers' AS segment_name
FROM $designers_puids AS designers
INNER JOIN `{indevice_yandexuid_matching}` AS matching
USING (id, id_type);
"""

USLUGI_WORKERS_CUBE_TABLE = '//home/geo-search/uslugi/logs/squeeze/workers/workers_cube'


class InteriorDesigners(LalSampleBuilder):
    def requires(self):
        return ExternalInput(USLUGI_WORKERS_CUBE_TABLE)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=query_template.format(
                input_table=inputs.table,
                indevice_yandexuid_matching=config.INDEVICE_YANDEXUID,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )

        self.yt.set_attribute(
            output_path,
            'generate_date',
            self.date
        )

        self.prepare_samples_for_lal(
            input_table=output_path,
            id_field='yandexuid',
            lals_params=[LaLParams(
                name='interior_designers',
                id=18658285,
                type='audience_segments',
                coverage=5000000,
                include_input=False,
            )],
        )
