#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LalSampleBuilder,
    LaLParams,
)

Q_ANSWERS_TABLE = '//home/answers/pg_dumps/production/latest/answers__answers'
Q_USERS_TABLE = '//home/answers/pg_dumps/production/latest/answers__users'

q_answering_users_query_template = """
$answered = (
    SELECT
        t1.yandex_uid AS id,
        'puid' AS id_type,
        'q_answering_users' AS segment_name
    FROM `{users_table}` AS t1
    INNER JOIN (
        SELECT DISTINCT author_id
        FROM `{answers_table}`
        WHERE created > '{last_date}'
    ) AS t2
    ON t1.id == t2.author_id
    WHERE t1.yandex_uid IS NOT NULL
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT
    matching.yandexuid AS yandexuid,
    q_users.segment_name AS segment_name
FROM $answered AS q_users
INNER JOIN `{indevice_yandexuid_matching}` AS matching
USING (id, id_type)
"""


class QAnsweringUsers(LalSampleBuilder):
    def requires(self):
        return {
            'answers': ExternalInput(Q_ANSWERS_TABLE),
            'users': ExternalInput(Q_USERS_TABLE),
        }

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=q_answering_users_query_template.format(
                users_table=inputs['users'].table,
                answers_table=inputs['answers'].table,
                indevice_yandexuid_matching=config.INDEVICE_YANDEXUID,
                last_date=date_helpers.get_date_from_past(self.date, months=3),
                output_table=output_path,
            ),
            transaction=self.transaction,
        )

        self.yt.set_attribute(
            output_path,
            'generate_date',
            self.date
        )

        self.prepare_samples_for_lal(
            input_table=output_path,
            id_field='yandexuid',
            lals_params=[LaLParams(
                name='q_answering_users',
                id=1897,
                type='lal_internal',
                coverage=3000000,
                include_input=False,
            )],
        )
