#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInput
from crypta.profile.utils.segment_utils.builders import (
    LaLParams,
    LalSampleBuilder,
)


active_ultima_users_query_template = u"""
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$tariff_stat = (
    SELECT
        passport_uid AS puid,
        order_cnt,
        Yson::ConvertToUint64Dict(tariff_class_stat) AS tariff_stats,
    FROM `{taxi_user_profile_table}`
);

$tariff_stat = (
    SELECT
        puid,
        order_cnt,
        tariff_stat.0 AS tariff,
        tariff_stat.1 AS tariff_cnt,
    FROM $tariff_stat
    FLATTEN DICT BY tariff_stats AS tariff_stat
    WHERE tariff_stat.0 in {ultima_tariffs}
);

$by_puid = (
    SELECT
        puid,
        SOME(order_cnt) AS order_cnt,
        CAST(SUM(tariff_cnt) AS Double) / SOME(order_cnt) AS business_order_ratio,
    FROM $tariff_stat
    GROUP BY puid
);

INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    CAST(indevice_yandexuid.yandexuid AS String) AS yandexuid,
    'ultima_taxi_users' AS segment_name,
FROM $by_puid AS taxi
INNER JOIN `{indevice_yandexuid_matching}` AS indevice_yandexuid
ON taxi.puid == indevice_yandexuid.id
WHERE indevice_yandexuid.id_type == 'puid'
GROUP BY indevice_yandexuid.yandexuid
HAVING MAX(taxi.order_cnt) >= {min_order_cnt}
    AND MAX_BY(taxi.business_order_ratio, taxi.order_cnt) > {min_business_order_ratio};
"""


class UltimaTaxiUsers(LalSampleBuilder):
    def requires(self):
        return ExternalInput(config.TAXI_DATA_LOG)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            query_string=active_ultima_users_query_template.format(
                ultima_tariffs=('Cruise', 'Elite', 'Premier', 'Business'),
                min_order_cnt=10,
                min_business_order_ratio=0.3,
                taxi_user_profile_table=inputs.table,
                indevice_yandexuid_matching=config.INDEVICE_YANDEXUID,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )

        self.yt.set_attribute(
            output_path,
            'generate_date',
            self.date
        )

        self.prepare_samples_for_lal(
            input_table=output_path,
            id_field='yandexuid',
            lals_params=[LaLParams(
                name='ultima_taxi_users',
                id=17876938,
                type='audience_segments',
                coverage=10000000,
                include_input=True,
            )],
        )
