#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Crypta user profile log parser

Usage:
  main.py metrics [--log-file-path=<path>]
  main.py bar [--log-file-path=<path>]
  main.py reqans [--log-file-path=<path>]
  main.py geocube [--log-file-path=<path>]
  main.py bb [--log-file-path=<path>]
  main.py pp [--log-file-path=<path>]
  main.py mobile_bar [--log-file-path=<path>]
  main.py make_sample [--log-file-path=<path>]
  main.py (-h | --help)

Options:
  geocube                       Parse geocube log
  metrics                       Parse bs-watch-log
  bar                           Parse bar-navig-log
  reqans                        Parse reqans log
  bb                            Parse beh-profile-regular-log
  pp                            Parse superapp-metrika-mobile-log
  mobile_bar                    Parse browser-metrika-mobile-log
  make_sample                   Make a small sample of logs for testing
  --log-file-path=<path>        Path for logs
"""
from docopt import docopt

from crypta.profile.runners.log_parsing.lib import (
    bar,
    bb,
    geocube,
    make_sample,
    metrics,
    mobile,
    reqans,
)
from crypta.profile.utils.config import config


def main():
    arguments = docopt(__doc__)

    if arguments['--log-file-path']:
        config.LOCAL_LOGS_DIRECTORY = config.TASKS_LOGS_DIRECTORY = arguments['--log-file-path']
        config.LOCAL_STORAGE_DIRECTORY = arguments['--log-file-path']

    if arguments['metrics']:
        metrics.main()

    elif arguments['bar']:
        bar.main()

    elif arguments['reqans']:
        reqans.main()

    elif arguments['geocube']:
        geocube.main()

    elif arguments['bb']:
        bb.main()

    elif arguments['pp']:
        mobile.pp_runner()

    elif arguments['mobile_bar']:
        mobile.mobile_bar_runner()

    elif arguments['make_sample']:
        make_sample.main()


if __name__ == '__main__':
    main()
