#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Parse 5-min bar-navig-log and prepare daily tables

More info about bar-navig-log https://wiki.yandex-team.ru/browser/stat/nav/
"""
from library.python import resource

from crypta.profile.runners.log_parsing.lib.base_parser import LogParser
from crypta.profile.utils.config import config


class BarParser(LogParser):
    def __init__(self):
        super(BarParser, self).__init__(
            log_name='bar',
            log_dir=config.BAR_LOG_DIRECTORY,
            output_schema={
                'yandexuid': 'uint64',
                'icookie': 'uint64',
                'timestamp': 'uint64',
                'url': 'string',
                'referer': 'string',
                'host': 'string',
                'referer_host': 'string',
                'url_tail': 'string',
                'ip': 'string',
                'yasoft': 'string',
                'browser_language': 'string',
                'title': 'string',
                'lemmas': 'any',
            },
            query=resource.find("/query/bar.yql"),
            title='log_parsing {}'.format(self.__class__.__name__),
            udf_url_dict={
                'libcrypta_url_utils_udf.so': config.CRYPTA_URL_UTILS_UDF_URL,
            },
            yql_libs=[resource.find("/yql_lib/parse_url.yql")],
        )


def main():
    bar_parser = BarParser()
    bar_parser.run()


if __name__ == '__main__':
    main()
