#!/usr/bin/env python
# -*- coding: utf-8 -*-

from crypta.profile.runners.log_parsing.lib.base_parser import LogParser
from crypta.profile.utils.config import config


bb_query = """
PRAGMA yt.AutoMerge = 'disabled';

$kw409 = ($dump) -> {{
    RETURN ListFilter(
        Bigb::ParseProfile($dump).items,
        ($item) -> {{
            return $item.keyword_id == 409
        }}
    )
}};

INSERT INTO `{intermediate_table}` WITH TRUNCATE
SELECT
    yandexuid,
    dump_timestamp,
    `timestamp`,
    CAST(category AS Uint64) AS category
FROM (
    SELECT
        yandexuid,
        dump_timestamp,
        CAST(item.update_time AS Uint64) AS `timestamp`,
        item.uint_values AS category
    FROM (
        SELECT
            CAST(UniqID AS Uint64) AS yandexuid,
            CAST(`TimeStamp` AS Uint64) AS dump_timestamp,
            $kw409(ProfileDump) AS items
        FROM $input
        WHERE CAST(UniqID AS Uint64) IS NOT NULL
            AND CAST(UniqID AS Uint64) != 0
            AND ListLength($kw409(ProfileDump)) > 0
    )
    FLATTEN LIST BY items AS item
)
FLATTEN LIST BY category;
"""


class BbParser(LogParser):
    def __init__(self):
        super(BbParser, self).__init__(
            log_name='bb',
            log_dir=config.BEH_PROFILE_REGULAR_LOG_FOLDER,
            output_schema={
                'yandexuid': 'uint64',
                'timestamp': 'uint64',
                'category': 'uint64',
                'dump_timestamp': 'uint64',
            },
            query=bb_query,
            title='log_parsing {}'.format(self.__class__.__name__),
            udf_resource_dict={
                'bigb.so': config.BIGB_UDF_RESOURCE,
            },
        )


def main():
    bb_parser = BbParser()
    bb_parser.run()


if __name__ == '__main__':
    main()
