#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Parse 5-min bs-watch-log and prepare daily tables

More info about bs-watch-log https://wiki.yandex-team.ru/jandexmetrika/doc/watchlog/
"""
from library.python import resource

from crypta.profile.runners.log_parsing.lib.base_parser import LogParser
from crypta.profile.utils.config import config


class MetricsParser(LogParser):
    def __init__(self):
        super(MetricsParser, self).__init__(
            log_name='metrics',
            log_dir=config.METRICS_LOG_DIRECTORY,
            output_schema={
                'yandexuid': 'uint64',
                'icookie': 'uint64',
                'timestamp': 'uint64',
                'counter_id': 'uint64',
                'counter_is_rsya': 'boolean',
                'ip': 'string',
                'url': 'string',
                'referer': 'string',
                'host': 'string',
                'referer_host': 'string',
                'url_tail': 'string',
                'title': 'string',
                'lemmas': 'any',
                'browser_language': 'string',
                'region_id': 'uint64',
                'params': 'string',
                'timezone': 'int64',
                'event_type': 'string',
            },
            query=resource.find("/query/metrics.yql"),
            title='log_parsing {}'.format(self.__class__.__name__),
            udf_url_dict={
                'libcrypta_url_utils_udf.so': config.CRYPTA_URL_UTILS_UDF_URL,
            },
            yql_libs=[resource.find("/yql_lib/parse_url.yql")],
        )


def main():
    metrics_parser = MetricsParser()
    metrics_parser.run()


if __name__ == '__main__':
    main()
