#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Crypta user profile matching runner

Usage:
  main.py [--log-file-path=<path>]
  main.py (-h | --help)

Options:
  --log-file-path=<path>        Path for logs
"""

import datetime

import luigi
from docopt import docopt

from crypta.profile.lib import luigi_helpers

from crypta.profile.utils.config import config
from crypta.profile.runners.matching.lib.main_task import MatchingMainTask


def main():
    arguments = docopt(__doc__)

    if arguments['--log-file-path']:
        config.LOCAL_LOGS_DIRECTORY = config.TASKS_LOGS_DIRECTORY = arguments['--log-file-path']
        config.LOCAL_STORAGE_DIRECTORY = arguments['--log-file-path']

    luigi_helpers.setup_external_tasks_retry()

    result = luigi.run(
        [
            '--scheduler-url', config.LUIGI_SCHEDULER_URL,
            '--workers', '3',
            '--date', str(datetime.date.today()),
            '--log-level', 'INFO',
        ],
        main_task_cls=MatchingMainTask,
    )

    if not result:
        exit(1)


if __name__ == '__main__':
    main()
