#!/usr/bin/env python
# -*- coding: utf-8 -*-

import datetime

import luigi

from crypta.profile.lib import date_helpers
from crypta.profile.runners.matching.lib.dit import DitSocdemMatching
from crypta.profile.runners.matching.lib.drive import DriveSocdem
from crypta.profile.runners.matching.lib.email_tf_gender import EmailTfGender
from crypta.profile.runners.matching.lib.find_thresholds import FindThresholds as FindSocdemThresholds
from crypta.profile.runners.matching.lib.get_labeled_socdem import GetLabeledSocdem
from crypta.profile.runners.matching.lib.get_matching_samples_for_testing import (
    GetYuidWithAllSample,
    GetVerticesSample,
)
from crypta.profile.runners.matching.lib.income.prepare_income_for_socdem_storage import PrepareIncomeForSocdemStorage
from crypta.profile.runners.matching.lib.mobile_app_categories import GetMobileAppCategories
from crypta.profile.runners.matching.lib.mobile_logs_socdem import MobileInstallLogSocdem
from crypta.profile.runners.matching.lib.passport_socdem import PassportSocdem
from crypta.profile.runners.matching.lib.peoplesearch_socdem import PeopleSearchSocdem
from crypta.profile.runners.matching.lib.socdem_by_metrics_and_bar import MetricsAndBarVKSocdem
from crypta.profile.runners.matching.lib.social_auth import SocialAuthSocdem
from crypta.profile.runners.matching.lib.voice_socdem import GetVoiceSocdem
from crypta.profile.utils.config import config


class MatchingMainTask(luigi.WrapperTask):
    date = luigi.Parameter()

    def requires(self):
        today = self.date
        yesterday = date_helpers.get_yesterday(self.date)

        tasks = [
            GetMobileAppCategories(today),

            DriveSocdem(today),
            PassportSocdem(yesterday),
            SocialAuthSocdem(yesterday),
            PeopleSearchSocdem(today),
            DitSocdemMatching(today),
            EmailTfGender(today),
            GetVoiceSocdem(today),
            MobileInstallLogSocdem(yesterday),
            MetricsAndBarVKSocdem(yesterday),

            FindSocdemThresholds(yesterday),
            PrepareIncomeForSocdemStorage(today),
            GetLabeledSocdem(today),
        ]

        if config.environment == "production":
            tasks += [
                GetYuidWithAllSample(today),
                GetVerticesSample(today),
            ]

        return tasks


def main():
    luigi.run(
        [
            '--scheduler-url', config.LUIGI_SCHEDULER_URL,
            '--workers', '3',
            '--date', str(datetime.date.today())
        ],
        main_task_cls=MatchingMainTask
    )


if __name__ == '__main__':
    main()
