#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.profile.lib import date_helpers

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import ExternalInputDate
from crypta.profile.utils.segment_utils.builders import RegularSegmentBuilder


select_age_18_20_yql_template = """
$sources_new_age = (
    SELECT matching.cryptaId AS cryptaId,
         CASE
            WHEN '{eighteenth_birthday}' >= socdem_storage.birth_date AND
                socdem_storage.birth_date > '{twenty_first_birthday}' THEN '18_20'
            ELSE 'other'
        END AS segment_name
    FROM `{socdem_storage_table}` AS socdem_storage
    INNER JOIN `{id_to_crypta_id_table}` AS matching
    ON socdem_storage.id == matching.id AND socdem_storage.id_type == matching.id_type
    WHERE socdem_storage.birth_date is not Null
);

$sources_mode_age = (
    SELECT cryptaId, MODE(segment_name)[0].Value AS segment_name
    FROM $sources_new_age
    GROUP BY cryptaId
);

INSERT INTO `{output_table}` WITH TRUNCATE

SELECT matching.id AS id,
    matching.id_type AS id_type,
    sources.segment_name AS segment_name
FROM $sources_mode_age AS sources
INNER JOIN `{crypta_id_to_id_table}` AS matching
USING(cryptaId)
WHERE sources.segment_name == '18_20' AND matching.id_type == 'yandexuid';
"""


class AgeSegmentEighteenTwenty(RegularSegmentBuilder):
    name_segment_dict = {
        '18_20': 16003102,
    }

    keyword = 557

    def requires(self):
        return ExternalInputDate(config.SOCDEM_STORAGE_TABLE, date=self.date)

    def build_segment(self, inputs, output_path):
        self.yql.query(
            select_age_18_20_yql_template.format(
                socdem_storage_table=inputs.table,
                eighteenth_birthday=date_helpers.get_date_from_past(self.date, years=18),
                twenty_first_birthday=date_helpers.get_date_from_past(self.date, years=21),
                id_to_crypta_id_table=config.VERTICES_NO_MULTI_PROFILE,
                crypta_id_to_id_table=config.VERTICES_NO_MULTI_PROFILE_BY_CRYPTA_ID,
                output_table=output_path,
            ),
            transaction=self.transaction,
        )
